package gov.va.med.mhv.admin.converter;

import gov.va.med.mhv.admin.dto.EmployeeDTO;
import gov.va.med.mhv.admin.dto.EmployeeOrgRoleDTO;
import gov.va.med.mhv.admin.model.Employee;
import gov.va.med.mhv.admin.model.EmployeeOrgRole;

import java.util.ArrayList;
import java.util.List;

import org.springframework.stereotype.Component;

@Component
public class EmployeeConverter {
	
    public static EmployeeDTO convert(Employee employee){
    	
    	EmployeeDTO dto = new EmployeeDTO();
    	dto.setComments(employee.getComments());
    	dto.setCurrentLoginDate(employee.getCurrentLoginDate());
    	dto.setEmployeeId(employee.getId());
    	dto.setFirstName(employee.getFirstName());
    	dto.setLastName(employee.getLastName());
    	dto.setLastLoginDate(employee.getLastLoginDate());
    	dto.setOplock(employee.getOplock());
    	dto.setUserName(employee.getUserName());
    	List<EmployeeOrgRoleDTO> orgRoleDTOs=new ArrayList<EmployeeOrgRoleDTO>();
    	if(employee.getEmployeeOrgRoles() != null){
	    	for(EmployeeOrgRole orgRole:employee.getEmployeeOrgRoles()){
	    		EmployeeOrgRoleDTO orgRoleDTO =OrgRoleConverter.convert(orgRole);
	    		orgRoleDTOs.add(orgRoleDTO);
	    	}
    	}
    	dto.setEmployeeOrgRoles(orgRoleDTOs);
    	return dto;
    }
    
    

    public static Employee convert(EmployeeDTO employee){
    	
    	
    	Employee dto = new Employee();
    	dto.setComments(employee.getComments());
    	dto.setCurrentLoginDate(employee.getCurrentLoginDate());
    	dto.setId(employee.getEmployeeId());
    	dto.setFirstName(employee.getFirstName());
    	dto.setLastName(employee.getLastName());
    	dto.setLastLoginDate(employee.getLastLoginDate());
    	dto.setOplock(employee.getOplock());
    	dto.setUserName(employee.getUserName());
    	List<EmployeeOrgRoleDTO> orgRoleDTOs=new ArrayList<EmployeeOrgRoleDTO>();
    	if(employee.getEmployeeOrgRoles() != null){
	    	for(EmployeeOrgRoleDTO orgRole:employee.getEmployeeOrgRoles()){
	    		orgRoleDTOs.add(orgRole);
	    	}
    	}
    	dto.setEmployeeOrgRoles(OrgRoleConverter.convertList(orgRoleDTOs));
    	return dto;
    }

}
